<?php
function azcodeGenerateSession($length = 5) {
    $characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $token = '';
    $maxRandIndex = strlen($characters) - 1;

    for ($i = 0; $i < $length; $i++) {
        $token .= $characters[random_int(0, $maxRandIndex)];
    }

    return $token;
}

function saveSessionToken($token) {
    $_SESSION['secToken'] = $token;
}

function getSessionToken() {
    if (isset($_SESSION['secToken'])) {
        return $_SESSION['secToken'];
    }
    return null;
}

function validateSessionToken($token) {
    if ($token === getSessionToken()) {
        return true;
    }
    return false;
}

session_start();
if (!isset($_SESSION['userAgent']) || $_SESSION['userAgent'] !== $_SERVER['HTTP_USER_AGENT']) {
    session_regenerate_id(true);
    $_SESSION['userAgent'] = $_SERVER['HTTP_USER_AGENT'];
}

if (!isset($_SESSION['secToken'])) {
    $securityToken = azcodeGenerateSession(5);
    saveSessionToken($securityToken);
} else {
    $securityToken = getSessionToken();
}

if (isset($_POST['azcodeToken'])) {
    $azcodeToken = $_POST['azcodeToken'];

    if (validateSessionToken($azcodeToken)) {
        echo "<form id='azcodeSub' method='POST' action='index.php?gToken=verified'>
        <input type='hidden' name='sessionToken' value='azf'>
        </form>
        <script type='text/javascript'>document.getElementById('azcodeSub').submit();</script>";
    } else {
        echo "<script>alert('Sandi yang Anda masukkan salah!'); window.location='verify.php';</script>";
    }
}
?>
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Konfirmasi: Anda Bukan Robot!</title>
    <meta author="AzCode">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">
    <style>
        body {
            background: white;
        }
        
        .azcode-head {
            color: black;
            font-weight: bold;
            text-align: center;
        }
        
        .azcode-desk {
            color: black;
        }
        
    </style>
  </head>
  <body>
    <div class="container text-center">
        <h1 class="azcode-head mt-4">SAYA BUKAN ROBOT</h1>
        
    <form method="POST">
    <div class="input-group flex-nowrap mb-3">
      <input type="hidden" name="azcodeToken" class="form-control" placeholder="Password" value="<?=$_SESSION['secToken'];?>" required>
    </div>
    
    <div class="form-check mb-3" style="text-align: left;">
      <input class="form-check-input" type="checkbox" id="azcodeCheck" required>
      <b>
      <label class="form-check-label" for="azcodeCheck">
        Klik kotak kecil di samping untuk mengkonfirmasi bahwa anda bukan robot dan melanjutkan ke dalam videy
      </label>
      </b>
    </div>
    
    <div class="d-grid gap-2">
      <button class="btn btn-primary" type="submit">Lanjutkan</button>
    </div>
    </form>
        
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js" integrity="sha384-HwwvtgBNo3bZJJLYd8oVXjrBZt8cqVSpeBNS5n7C8IVInixGAoxmnlMuBnhbgrkm" crossorigin="anonymous"></script>
    
  </body>
</html>